//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NTAG5Strings.h"
#import "NTAG5_NFC_LIB.h"
#import "ISO15693Command.h"
#import "RFCommands.h"

NS_ASSUME_NONNULL_BEGIN

@interface Config: NSObject

+ (Config *) sharedInstance;

/*!
 *@abstract   Call this method to get the current use case configuration
 **/
- (void) getUseCaseConfig: (void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   reads response of cmd_readTagConfig and returns a use case depending on its value
 *@param resp  is the response of cmd_readTagConfig.
 **/
- (NSString *) parseUseCaseConfig:(NSData *)resp;

/*!
 *@abstract   sets I2C Slave Mode
 **/
- (void) setI2CSlave:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   sets I2C Master Mode
 **/
- (void) setI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   sets GPIO/PWM Mode
 **/
- (void) setGPIOPWM:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

@end

NS_ASSUME_NONNULL_END
